﻿var notificationSettingsPage = {
    context: ".v-notificationSettings",
    initialize: function () {
        this.initServerSide();        
    },
    getColumns: function () {
        var columns = [
        { "Name": "Id", "Title": "Id", "Data": "Id", "HideInSelector": true, "Visible": false },
        { "Name": "GroupId", "Title": "GroupId", "Data": "GroupId", "HideInSelector": true, "Visible": false },
        {
            "Name": "GroupName", "Title": resources.type, "Data": "GroupName",
            "Type": "enum", "EnumType": "EventGroupTypes"
        },
        {
            "Name": "EventTypeName", "Title": resources.event, "Data": "EventName", "AdvancedFilter": false,
            "Type": "enum", "EnumType": "EventTypes"
        },
        {
            "Name": "SendNotification", "Title": resources.alert, "Type": "boolean", "AdvancedFilter": false, "Sortable": false,
            "ShowIcon": true, "Editable": { "Nullable": false }
        },
        {
            "Name": "SendEmail", "Title": resources.email, "Type": "boolean", "ShowIcon": true, "AdvancedFilter": false, "Sortable": false,
            "Editable": { "Nullable": false }
        },
        {
            "Name": "Priority", "Title": resources.frequency, "Data": "PriorityLabel", "Sortable": false,
            "Type": "enum", "EnumType": "Priorities", "AdvancedFilter": false,
            "Editable": "([SendNotification]==true||[SendEmail]==true)",
        }]
        return columns;
    },
    initServerSide: function(){
        $(".h-notif-table", notificationSettingsPage.context).a4datatable({
            ajaxAction: a4.getAction("GetNotificationSettings", "SystemNotification", "SystemNotification"),
            serverSide: true,
            advancedFilter: true,
            displaySearchBox: true,
            displayColumnSelector: false,
            rememberRowSelection: false,
            allowRowSelection: false,
            height: "full",
            multiEdit: true,
            columns: notificationSettingsPage.getColumns(),
            rowUpdated: function (event, data) {
                var row = data.data;
                var notificationMustBeSent = (row.SendEmail || row.SendNotification);
                var frequencyIsNull = (row.Priority === null || row.Priority === "" || row.Priority === 0);

                if (notificationMustBeSent && frequencyIsNull)
                    data.flagError(true, true);                
            },
            rowsUpdated: function (event, data) {
                a4.callServerMethod(a4.getAction("UpdateNotificationSettings", "SystemNotification", "SystemNotification"), { data: data.rows }, function () {
                    data.multiEditSaveCallback();
                });
            }
        });
    }
}

$(document).ready(function () {
    if (notificationSettingsPage.context.length > 0) {
        notificationSettingsPage.initialize();
    }
});